/*
	-----------------------------------------------------------------------------

	               --- CAEN SpA - Computing Systems Division --- 

	-----------------------------------------------------------------------------

	CAENRFIDTypes.h

	-----------------------------------------------------------------------------

	Created: May 2023

	Version 5.0.0

  	-----------------------------------------------------------------------------
*/
#ifndef _WINSOCK2API_
#include <winsock2.h>
#endif

#define MAX_ID_LENGTH							64
#define XPC_LENGTH								4
#define PHASE_LENGTH                            4
#define PC_LENGTH								2
#define MAX_ARG_SIZE							50
#define MAX_CLIENT_SUPPORTED					20
#define MAX_READPOINT_NAME						5
#define MAX_LOGICAL_SOURCE_NAME					30
#define MAX_TID_SIZE							64
#define MAX_FWREL_LENGTH						201	//stringa che rappresenta il fw release (SOLO solo nella libreria C)
#define MAX_SWREL_LENGTH						6	//stringa che rappresenta il sw release	(SOLO nella libreria C)
#define MAX_MODEL_LENGTH						10	//stringa che rappresenta il modello del reader
#define MAX_SERIAL_LENGTH						100 //stringa che rappresenta il numero seriale del reader
#define evUnknown                               0
#define evGlimpsed                              1
#define EvNew                                   2
#define evObserved                              3
#define evLost                                  4
#define evPurged                                5
#define TWOBITE									2
#define TIMELENGTH								19

typedef int CAENRFIDHandle;

/*
        Error codes
*/


typedef enum {
	// -------------------- GENERAL ERROR CODES 
	CAENRFID_StatusOK					       =  0,  // Operation completed successfully 
    CAENRFID_TooManyClientsError			   = -1,  // To many clients open 
	CAENRFID_PortError					       = -2,  // Error on selected port
	CAENRFID_LibraryError				       = -3,  // Can't open winsock 2.2 Library
	CAENRFID_SocketError				       = -4,  // Can't open socket
	CAENRFID_InvalidHandleError				   = -5,   // Invalid Handle
	CAENRFID_OutOfMemoryError			       = -6,
	CAENRFID_CommunicationError			       = -7,
	CAENRFID_CommunicationTimeOut		       = -8,
	CAENRFID_ChannelExist				       = -9,
	CAENRFID_GenericError				       = -10, // Generic error
	CAENRFID_InvalidParam				       = -11,  // Invalid parameter error
	CAENRFID_ReaderBusy						   = -12,
	CAENRFID_EOF							   = -13,	
	//--------------------- FIRMWARE ERROR CODES (communication specific)
	CAENRFID_ChanNameExistsError			   = 100,
	CAENRFID_AddrAlreadyInUseError			   = 101,
	CAENRFID_UnknowError					   = 102,
	CAENRFID_BadChannelError				   = 103,
	CAENRFID_InvalidSourceNamError			   = 104,
	CAENRFID_InvalidChannelNameError		   = 105,
	CAENRFID_TooManyChannelError			   = 106,
	CAENRFID_TooManySourceError				   = 107,
	CAENRFID_SourceNotInChannelError		   = 109,
	CAENRFID_BadTimerValueError				   = 110,
	CAENRFID_TriggerNameExistError			   = 111,
	CAENRFID_TooManyTriggerError			   = 112,
	CAENRFID_BadTriggerError				   = 113,
	CAENRFID_BadAddressError				   = 114,
	CAENRFID_InvalidProtocolError			   = 115,
	CAENRFID_BadPortAddressError			   = 116,
	CAENRFID_CannotConnectToServerError		   = 117,
	CAENRFID_InvalidTriggerNameError		   = 118,
	CAENRFID_InvalidTimeError				   = 119,
	CAENRFID_SourceNotFoundError			   = 120,
	CAENRFID_TriggerNotFoundError			   = 121,
	CAENRFID_ChannelNotFoundError			   = 122,
	CAENRFID_BadReadPointError				   = 123,
	CAENRFID_ChannelBusyError				   = 124,
	CAENRFID_TriggerBusyError				   = 125,
	CAENRFID_InternalFilesystemError		   = 126,
	CAENRFID_InvalidCommand					   = 127,
	CAENRFID_BadParameterValueError			   = 128,
	CAENRFID_NotifyServerNotReadyError		   = 129,
	CAENRFID_PowerValueOutofRangeError		   = 183,
	CAENRFID_TimeoutError                      = 199,
	CAENRFID_InvalidParameterError			   = 200,
	CAENRFID_LogicalSourceDisabledError		   = 201,
	CAENRFID_TagNotPresentError				   = 202,
	CAENRFID_WritingTagError				   = 203,
	CAENRFID_ReadingTagError				   = 204,
	CAENRFID_BadTagAddressError				   = 205,
	CAENRFID_InvalidFunctionError			   = 206,
	CAENRFID_SelectUnselectError			   = 207,
	CAENRFID_TagLockedError				       = 209,
	CAENRFID_UnsupportedError				   = 210,
	CAENRFID_PowerError						   = 211,
	CAENRFID_NonSpecificError				   = 212,
	CAENRFID_KillTagError					   = 213,
	CAENRFID_ChannelsFullError				   = 214,
	CAENRFID_ErrorMatchReadpoint			   = 215
} CAENRFIDErrorCodes;

/*
        Communication ports enum
*/

typedef enum { 
	CAENRFID_RS232   = 0,
//	RS485   = 1, Obsolete
	CAENRFID_TCP     = 2, 
	CAENRFID_USB     = 3 
} CAENRFIDPort;

typedef enum {
	CAENRFID_ISO18000_6B   = 0,
	CAENRFID_EPC_C1G1      = 1,
	CAENRFID_ISO18000_6A   = 2,
	CAENRFID_KEEP_ALIVE    = 2,
	CAENRFID_EPC_C1G2	   = 3,
	CAENRFID_MULTIPROTOCOL = 4,
	CAENRFID_EPC119		   = 5
} CAENRFIDProtocol;

typedef enum {
        EPC_C1G2_SESSION_S0     = 0,
        EPC_C1G2_SESSION_S1     = 1,
        EPC_C1G2_SESSION_S2     = 2,
        EPC_C1G2_SESSION_S3     = 3,
        EPC_C1G2_TARGET_A       = 0,
        EPC_C1G2_TARGET_B       = 1,
        EPC_C1G2_SELECTED_YES   = 3,
        EPC_C1G2_SELECTED_NO    = 2,
        EPC_C1G2_ALL_SELECTED   = 0,
        ISO18006B_DESB_ON       = 1,
        ISO18006B_DESB_OFF		= 0,
}CAENRFIDLogicalSourceConstants ;

typedef enum { 
	RESERVED   = 0,
	EPC        = 1,
	TID        = 2, 
	USER       = 3 
} CAENRFIDMemBank;


typedef enum {
	INVSUBCMD_NONE = 0,
	INVSUBCMD_G2READ = 1,
	INVSUBCMD_G2WRITE = 2
} CAENRFID_InventorySubCommandType;

typedef struct {
	CAENRFID_InventorySubCommandType commandType;
	CAENRFIDMemBank memoryBank;
	short startWordAddress;
	short wordsCount;
	byte* wordsToWrite;
	int accessPassword;
} CAENRFID_InventorySubCommand;

/*
        Tag identification struct: for each tag it contains 
        the ID, the length of the ID and the antenna used to 
        identify the tag.
*/

typedef struct {
    byte                ID[MAX_ID_LENGTH];
    short               Length;
    char				LogicalSource[MAX_LOGICAL_SOURCE_NAME];
	char				ReadPoint[MAX_READPOINT_NAME];
    struct timeval		TimeStamp;
	CAENRFIDProtocol	Type;
	short				RSSI;
	byte				TID[MAX_TID_SIZE];
	short				TIDLen;
	byte				XPC[XPC_LENGTH];
	byte				PC[PC_LENGTH];
	float               phaseBegin;
	float               phaseEnd;
	long                frequency;
	CAENRFID_InventorySubCommandType subCmdCode;
	CAENRFIDErrorCodes               subCmdResultCode;
	short                            subCmdResultDataCount;
	byte* subCmdResultData;
} CAENRFIDTag;


typedef struct {
    byte                             ID[MAX_ID_LENGTH];
	short                            Length;
    int					             EvtType;
	CAENRFIDProtocol	             Type;
    char				             LogicalSource[MAX_LOGICAL_SOURCE_NAME];
	struct timeval		             TimeStamp;
	short			 	             RSSI;
	char				             ReadPoint[MAX_READPOINT_NAME];
	byte				             TID[MAX_TID_SIZE];
	short				             TIDLen;
	byte				             XPC[XPC_LENGTH];
	byte				             PC[PC_LENGTH];
	float                            phaseBegin;
	float                            phaseEnd;
	long                             frequency;
	CAENRFID_InventorySubCommandType subCmdCode;
	CAENRFIDErrorCodes               subCmdResultCode;
	short                            subCmdResultDataCount;
	byte*                            subCmdResultData;

} CAENRFIDNotify;


typedef CAENRFIDErrorCodes (__cdecl *CAENRFID_INVENTORY_CALLBACK)(const CAENRFIDNotify* Tags, const int Size);

typedef enum {
	STATUS_GOOD		= 0,
	STATUS_POOR		= 1,
	STATUS_BAD		= 2
} CAENRFIDReadPointStatus;

typedef enum {
        CAENRS232_Parity_None      = 0,
        CAENRS232_Parity_Odd       = 1,
        CAENRS232_Parity_Even      = 2     
} CAENRFID_RS232_Parity;

typedef enum {

        CAENRFID_RS232_FlowControl_XonXoff    = 2,
        CAENRFID_RS232_FlowControl_Hardware   = 1,
        CAENRFID_RS232_FlowControl_None       = 0
}CAENRFID_RS232_FlowControl;

/*obsolete*/
typedef enum {
		SEL_EQUAL			=	0x00,    /* comparazione di uguaglianza */
		SEL_NOT_EQUAL		=	0x01,    /* comparazione di disuguaglianza */
		SEL_GREATER_THAN	=	0x02,    /* comparazione di maggioranza */
		SEL_LOWER_THAN		=	0x03,    /* comparazione di maggioranza */
		UNS_EQUAL			=	0x04,    /* comparazione di uguaglianza */
		UNS_NOT_EQUAL		=	0x05,    /* comparazione di disuguaglianza */
		UNS_GREATER_THAN	=	0x06,    /* comparazione di maggioranza */
		UNS_LOWER_THAN		=	0x07    /* comparazione di maggioranza */
} CAENRFID_SelUnsel_Op;

/*obsolete*/
typedef enum {
		CONFIG_READCYCLE			= 0,
		CONFIG_OBSERVEDTHRESHOLD	= 1,
		CONFIG_LOSTTHRESHOLD		= 2,
		CONFIG_G2_Q_VALUE			= 3,
		CONFIG_G2_SESSION			= 4,
		CONFIG_G2_TARGET			= 5,
		CONFIG_G2_SELECTED			= 6,
		CONFIG_ISO18006B_DESB		= 7,
		CONFIG_DWELL_TIME           = 8,
        CONFIG_INV_COUNT            = 10,
		CONFIG_MIN_G2_Q             = 11,
		CONFIG_MAX_G2_Q             = 12,
		CONFIG_TID_LENGTH			= 13,
		CONFIG_QUIETTIME            = 15,
		CONFIF_NUM_MIN_G2_Q         = 16


} CAENRFID_SOURCE_Parameter;

typedef enum {
		READCYCLE_MODE				= 0,
		TIME_MODE					= 1,
		NOEVENT_MODE				= 2 
} CAENRFID_EventMode;

typedef enum {
	RSSI					=1,
	FRAMED					=2,
	CONTINUOS				=4,
	COMPACT					=8,
	TID_READING				=16,
	EVENT_TRIGGER			=32,
	XPC						=64,
	PC						=256,
	SW_TRIGGER              =512,
	RET_EVENTS              =1024,
	CLEAR_BUFFER            =2048,
	KEEP_ALIVE              =4096,
	PHASE                   =8192,
	FREQUENCY               =16384,
	RESERVEDFLAG            =32768,
} CAENRFID_InventoryFlag;

typedef enum {
		RFID_TFTP					= 1
} CAENRFID_FWUpgradeType;

/*obsolete. USe CAENRFID_EventInventoryParams instead.*/
typedef struct {
	char					*SourceName; 
	char						*Mask;
	unsigned char				MaskLength;
	unsigned char				Position;
	CAENRFID_INVENTORY_CALLBACK	pCallBack;
	short						flag;
} CAENRFID_ExtendedInventoryParams;

typedef struct {
	char					*SourceName; 
	char						*Mask;
	unsigned char				MaskLength;
	unsigned char				Position;
	CAENRFID_INVENTORY_CALLBACK	pCallBack;
	unsigned short			    flag;
} CAENRFID_EventInventoryParams;

typedef struct {
    BOOL				ADError_i;
	unsigned int		RangeLimit_i;
	unsigned int		SensorValue_i;
} CAENRFID_IDSTagData;

typedef enum{
	TX10RX40 = 1,
	TX40RX40 = 2,
	TX40RX160 = 3,
	DSB_ASK_FM0_TX10RX40 =   1,
	DSB_ASK_FM0_TX40RX40 =   2,
	DSB_ASK_FM0_TX40RX160 =  3,
	DSB_ASK_FM0_TX160RX400 = 4,
	DSB_ASK_M2_TX40RX160 =   5,
	PR_ASK_M4_TX40RX250 =    6,
	PR_ASK_M4_TX40RX300 =    7,
	PR_ASK_M2_TX40RX250 =    8,
	DSB_ASK_M4_TX40RX256 =   10,
	PR_ASK_M4_TX40RX320 =    11,
	PR_ASK_FM0_TX40RX640 =   12,
	PR_ASK_M4_TX80RX320 =    13,
	PR_ASK_M4_TX40RX256 =    14,
	DSB_ASK_M8_TX40RX256 =   15,
	PR_ASK_M2_TX133RX640 =   16,
	PR_ASK_M2_TX50RX320 =    17,
	PR_ASK_M4_TX50RX320 =    18,
	PR_ASK_M4_TX50RX250 =    19,
	PR_ASK_FM0_TX133RX640 =  20,
	PR_ASK_M2_TX66RX320 =    21,
	PR_ASK_M8_TX50RX160 =    22,
	PR_ASK_M4_TX133RX640 =   23,
	DSB_ASK_FM0_TX160RX640 = 24,
	DSB_ASK_M2_TX160RX640 =  25,
	PR_ASK_FM0_TX66RX426 =   26

}CAENRFID_Bitrate;

typedef enum{

	ETSI_302208		 =0,
	ETSI_300220		 =1,
	FCC_US			 =2,
	MALAYSIA		 =3,
	JAPAN			 =4,
	KOREA			 =5,
	AUSTRALIA		 =6,
	CHINA			 =7,
	TAIWAN			 =8,
	SINGAPORE		 =9,
	BRAZIL			 =10,
	JAPAN_STD_T106	 = 11,
	JAPAN_STD_T107	 = 12,
	PERU			 = 13,
	SOUTH_AFRICA	 = 14,
	CHILE            = 15,
	JAPAN_STD_T106_L = 16,
	HONG_KONG        = 17,
	INDONESIA        = 18,
	ISRAEL           = 19,
	RUSSIA           = 20,
	NEW_ZELAND       = 21
	
}CAENRFIDRegulations;

typedef enum{

	RPCMATCHRFALG =14

}CAENRFIDMatchingParams;

/*Obsolete defines*/
#define	ETSI302208 0
#define	ETSI300220 1
#define	FCCUS      2
#define	MALAYSIA   3
#define	JAPAN      4
#define	KOREA      5
#define	AUSTRALIA  6
#define CHINA      7
#define TAIWAN     8
#define SINGAPORE  9
